#||Teams & Other Settings||
difficulty hard

#Teams
team add Ingame
team add lobby
team add Spectators
team modify Ingame color gold
team modify lobby color green
team modify Ingame seeFriendlyInvisibles false

#Adventure Mode & Clear
execute as @a[team=lobby] at @s unless entity @s[tag=dev] run gamemode adventure @s
clear @a[team=lobby,tag=!dev,nbt=!{Inventory:[{id:"minecraft:cooked_porkchop",tag:{display:{Name:'{"text":"Bacon"}'}}}]}]

#||Lobby Misc||

#Edge Reset
execute as @a[team=lobby] at @s if entity @s[y=0,dy=2] run tp @s 9.0 41 6.0

#Powder Activations
execute as @a[team=lobby] at @s if block ~ ~-1 ~ orange_concrete_powder run tp @s -217.5 19 -165.5
execute as @a[team=lobby] at @s if block ~ ~-1 ~ light_blue_concrete_powder run tp @s -372.5 18 -226.5 facing -362 19 -227
execute as @a[team=lobby] at @s if block ~ ~-1 ~ lime_concrete_powder run function usdp:start

#New Player Scoreboard Presentation
scoreboard players add @a Wins 0
scoreboard players add @a Coins 0

#Egg Insurance
execute as @e[type=goat] at @s if entity @s[y=0,dy=2] run tp @s 9.0 41 6.0

#Bacon
data merge block 1 41 6 {Items:[{Slot:13b,id:"minecraft:cooked_porkchop",Count:64b,tag:{display:{Name:'{"text":"Bacon"}'}}}]}
kill @e[type=item,nbt={Item:{id:"minecraft:cooked_porkchop"}}]

#EggHitBox
execute as @e[type=goat,name="Egg"] at @s run tp @e[type=interaction,tag=EggHitBox] ~ ~ ~ 

#||Class Functionality||

#Crazed Fisherman
execute as @e[type=minecraft:fishing_bobber,nbt={OnGround:1b}] unless score Yes started matches 0 at @s run summon tnt ~ ~ ~ {Fuse:40}
kill @e[type=fishing_bobber,nbt={OnGround:1b}]
execute as @a[tag=crazed_fisherman,scores={FishingRod=2..}] at @s unless entity @s[tag=used] run function usdp:crazed_fisherman_tnt
execute unless entity @e[type=fishing_bobber,nbt={OnGround:0b}] run clear @a[tag=crazed_fisherman,scores={FishingRod=2..}] fishing_rod
scoreboard players add @a FishingRod 0
execute as @e[type=fishing_bobber] at @s if entity @p[team=Ingame,distance=..1.65] run scoreboard players add @s HookedCount 1
execute as @e[type=fishing_bobber] at @s if entity @s[scores={HookedCount=20..}] run kill @s

#Archer
execute as @e[type=arrow,nbt={inGround:1b}] unless score Yes started matches 0 at @s run fill ~-2 ~-2 ~-2 ~2 ~2 ~2 air destroy
kill @e[type=arrow,nbt={inGround:1b}]

#Spy
execute as @a[tag=spy,scores={CarrotSticky=1..}] at @s unless entity @s[tag=used] run function usdp:spy_invis
execute as @a at @s if entity @s[level=0] if score @s CarrotSticky > @s NotReady run tellraw @s {"text": "Your ability isn't ready yet!","italic": true,"color": "red"}
execute as @a at @s store result score @s NotReady run scoreboard players get @s CarrotSticky
execute as @a[team=Ingame,tag=spy,level=1..] at @s run effect give @s speed 1 1 true

#Gymnast
effect give @a[team=Ingame,tag=gymnast] jump_boost infinite 2 true
effect give @a[team=Ingame,tag=gymnast] speed infinite 0 true

#Pacifist
effect give @a[team=Ingame,tag=pacifist] weakness infinite 4 true
execute as @a[team=Ingame,tag=pacifist] at @s run effect give @s slow_falling infinite 0 true

#||Status Effects||
scoreboard objectives add HP health
effect give @a[team=lobby,scores={HP=..19}] regeneration 1 255 true
effect give @a[team=lobby] saturation infinite 127 true
effect give @a resistance infinite 127 true
effect give @a[team=Ingame,scores={mined=1..}] saturation infinite 127 true
effect clear @a[team=Ingame,scores={mined=..1}] saturation
effect give @a haste infinite 127 true
effect give @a night_vision infinite 127 true
execute as @a[team=lobby] at @s if block ~ ~-1 ~ green_concrete run effect give @s jump_boost 1 9 true

#||Game Misc.||

#Giant Leap
execute as @a[scores={Giant_Leap=1}] at @s run function usdp:giant_leap

#Player Count In Match, PreGame Rescue, & Elimination Detection/Distribution
execute as @a[team=Ingame] at @s if entity @s[y=0,dy=2] if score Yes started matches 1 run scoreboard players remove Detection LastManStanding 1
execute as @a[team=Ingame] at @s if block ~ ~ ~ lava if score Yes started matches 1 run scoreboard players remove Detection LastManStanding 1
execute as @a[team=Ingame] at @s if score Yes started matches 1 if entity @s[y=0,dy=2] unless score Detection LastManStanding matches 1 run execute as @a at @s run playsound block.note_block.pling master @a ~ ~ ~ 1 2 1
execute as @a[team=Ingame] at @s if block ~ ~ ~ lava if score Yes started matches 1 unless score Detection LastManStanding matches 1 run execute as @a at @s run playsound block.note_block.pling master @a ~ ~ ~ 1 2 1

execute as @a[team=Ingame] at @s if score Yes started matches 1 if entity @s[y=0,dy=2] run team join Spectators @s
execute as @a[team=Ingame] at @s if block ~ ~ ~ lava if score Yes started matches 1 run team join Spectators @s

execute as @a[team=Ingame] at @s unless score Yes started matches 1 if entity @s[y=0,dy=2] run spreadplayers 231.5 120.5 2 50 true @s
execute as @a[team=Ingame] at @s if block ~ ~ ~ lava if score Yes started matches 0 run spreadplayers 231.5 120.5 2 50 false @s

spawnpoint @a[team=Spectators] 235 55 163
execute as @a[team=Spectators] at @s run gamemode spectator

#Winning
execute unless score Yes started matches 0 if score Detection LastManStanding matches 1 run schedule function usdp:finish 1t
execute unless entity @a[team=!lobby] run scoreboard players set Detection LastManStanding 0
kill @e[type=item,nbt={Item:{id:"minecraft:pointed_dripstone"}}]

execute as @a[team=Ingame] at @s if score Yes LobbyTime matches 0 run scoreboard players add Number PlayerCount 1
execute if score Yes LobbyTime matches 0 unless score Number PlayerCount matches 0 if score Number PlayerCount < Detection LastManStanding run scoreboard players remove Detection LastManStanding 1
execute if score Yes LobbyTime matches 0 unless score Number PlayerCount matches 0 if score Number PlayerCount > Detection LastManStanding run schedule function usdp:set_0_player_count 1t

#Midjoin/Ragequit Revitalized
team join lobby @a[team=]
execute as @r[team=Ingame] if score Yes started matches 1 at @s run tp @a[team=lobby] ~ ~ ~
execute as @a[team=lobby] if score Yes started matches 1 run scoreboard players set @s MidJoin 1
execute as @a[team=lobby] if score Yes started matches 1 run team join Spectators @s
execute as @a[team=Ingame] at @s if score Yes LobbyTime matches 1 run team join lobby
execute as @a[team=Spectators] at @s if score Yes LobbyTime matches 1 run team join lobby
scoreboard players add @a MidJoin 0

execute as @a[team=Ingame] at @s if score @s quit matches 1 if score Yes LobbyTime matches 1 run team join lobby
execute as @a[team=lobby] at @s if score @s quit matches 1 if score Yes LobbyTime matches 1 run effect clear @s
execute as @a[team=lobby] at @s if score @s quit matches 1 if score Yes LobbyTime matches 1 run tp @s 9.0 41 6.0
execute as @a[team=Ingame] at @s if score @s quit matches 1 if score Yes LobbyTime matches 0 run scoreboard players set @s MidJoin 1
execute as @a[team=Ingame] at @s if score @s quit matches 1 if score Yes LobbyTime matches 0 run team join Spectators @s
execute as @a[team=Spectators] at @s if score @s quit matches 1 if score Yes LobbyTime matches 0 run scoreboard players reset @s quit
execute as @a[team=lobby] at @s if score @s quit matches 1 if score Yes LobbyTime matches 1 run scoreboard players reset @s quit

#Ability Cooldown Insurance
execute as @a[scores={Ability_Cooldown=..-1}] at @s run scoreboard players set @s Ability_Cooldown 0

#Lava Clear
fill 263 19 121 216 19 149 air replace lava

#||Advancements||

#Mysterious Figure
execute as @a at @s if entity @e[type=sheep,distance=..1,name="Bear #7"] run advancement grant @s only ultimate_spleef:a_mysterious_figure

#Beginners Luck
advancement grant @a[scores={Wins=1..}] only ultimate_spleef:beginners_luck

#Amateur Hour
advancement grant @a[scores={Wins=15..}] only ultimate_spleef:amateur_hour

#Skill Or Fortune
advancement grant @a[scores={Wins=5..}] only ultimate_spleef:skill_or_fortune

#You're Kinda Good
advancement grant @a[scores={Wins=25..}] only ultimate_spleef:youre_kinda_good

#A Good Person
advancement grant @a[x=0,dx=7,y=57,dy=1,z=-0,dz=5] only ultimate_spleef:a_good_person

#Enlightenment
execute as @a[team=lobby,gamemode=adventure] at @s if block ~ ~-1 ~ barrier run advancement grant @s only ultimate_spleef:enlightenment

#||Trails||

#Equipped
execute as @a[tag=villager,team=!Spectators] unless entity @s[tag=spy,level=1..] at @s run particle minecraft:angry_villager ~ ~-.5 ~ .125 .125 .125 40 1 normal
execute as @a[tag=hearts,team=!Spectators] unless entity @s[tag=spy,level=1..] at @s run particle minecraft:heart ~ ~-.5 ~ .125 .125 .125 40 1 normal
execute as @a[tag=glow,team=!Spectators] unless entity @s[tag=spy,level=1..] at @s run particle minecraft:glow ~ ~ ~ .125 .125 .125 100 1 normal
execute as @a[tag=barrier,team=!Spectators] unless entity @s[tag=spy,level=1..] at @s run particle minecraft:block_marker barrier ~ ~-.125 ~ .125 .125 .125 1 1 normal
execute as @a[tag=lava,team=!Spectators] unless entity @s[tag=spy,level=1..] at @s run particle minecraft:dripping_lava ~ ~ ~ .125 .125 .125 20 1 normal
execute as @a[tag=glow_ink,team=!Spectators] unless entity @s[tag=spy,level=1..] at @s run particle minecraft:glow_squid_ink ~ ~ ~ .025 .025 .025 5 0 normal

execute as @a[team=lobby] if entity @s[tag=purchased_angry_villager,tag=purchased_barrier,tag=purchased_glow,tag=purchased_glow_ink,tag=purchased_hearts,tag=purchased_lava] at @s run advancement grant @s only ultimate_spleef:ballin

#||Must Mine Clock||
execute as @a[team=Ingame] run attribute @s minecraft:generic.max_health base set 4
execute as @a[team=lobby] run attribute @s generic.max_health base set 20

#||Actionbars||

execute as @a[team=lobby] at @s run title @s actionbar [{"text": "Wins: ","color": "dark_blue","bold": true},{"score":{"objective": "Wins","name":"@s"}},{"text": "    Coins: ","color": "gold","bold": true},{"score":{"name": "@s","objective": "Coins"},"color": "gold"}]

execute as @a[team=Ingame] unless entity @s[tag=crazed_fisherman] unless entity @s[tag=spy] at @s run title @s actionbar [{"text": "Must Mine Clock: ","bold": true,"color": "dark_green"},{"score":{"name": "@s","objective": "mined"},"bold": true,"color": "dark_green"}]
execute as @a[team=Ingame,tag=crazed_fisherman] unless score @s Ability_Cooldown matches 0 at @s run title @s actionbar [{"text": "Must Mine Clock: ","bold": true,"color": "dark_green"},{"score":{"name": "@s","objective": "mined"},"bold": true,"color": "dark_green"},{"text": "    Ability Cooldown: ","color": "green","bold": true},{"score":{"name": "@s","objective": "Ability_Cooldown"},"color": "green","bold": true},{"text": "s","color": "green","bold": true}]
execute as @a[team=Ingame,tag=crazed_fisherman] unless entity @s[scores={FishingRod=2..}] at @s run title @s actionbar [{"text": "Must Mine Clock: ","bold": true,"color": "dark_green"},{"score":{"name": "@s","objective": "mined"},"bold": true,"color": "dark_green"},{"text": "    Uses: ","color": "green","bold": true},{"score":{"name": "@s","objective": "FishingRod"},"color": "green","bold": true},{"text": "/2","color": "green","bold": true}]
execute as @a[team=Ingame,tag=spy] at @s run title @s actionbar [{"text": "Must Mine Clock: ","bold": true,"color": "dark_green"},{"score":{"name": "@s","objective": "mined"},"bold": true,"color": "dark_green"},{"text": "    Ability Cooldown: ","color": "green","bold": true},{"score":{"name": "@s","objective": "Ability_Cooldown"},"color": "green","bold": true},{"text": "s","color": "green","bold": true}]